;----------------------------------------------------------------------------
; Project: GPU Object List Example with ATARI Video Definitions
;
;
; Copyright (c) 2002 Duranik
; ALL RIGHTS RESERVED
;----------------------------------------------------------------------------
; Revision History:
; 22.02.2002 - Roland Graf
;----------------------------------------------------------------------------


	.ORG	$f03000
	.GPU
	
	
	INCLUDE "Jaguar.inc"		; ATARI Jaguar Definitionen
	INCLUDE	"Obj_List.inc"		; Aquarium Definitionen

	olist_ram	equ	$f03f44	; Adresse Copy OP-Liste
	obj_data	equ	$f03f48	; Adresse Objecte fr OP
	TOTAL_OBJS	equ	$f03f4C	; Anzahl Objecte
	a_vdb		equ	$f03f50 ; Y-Pos erste Bildschirmzeile

	
	
;-----------------------------------------------------------------------
; init GPU
;-----------------------------------------------------------------------
	movei	#G_FLAGS,r17		; GPU luft auf Registerbank 1
	load	(r17),r18
	bset	#3,r18			; Keine Interrupts bitte
	bclr	#14,r18
	store	r18,(r17)

	movei	#$f03f00,r31		; Stackpointer setzen
	moveta	r31,r31



;-----------------------------------------------------------------------
; OP Liste erstellen
;-----------------------------------------------------------------------
op_liste:
	movei   #OBJSIZE,r3		; Gre eines Objects in Byte (am Ende steht man auf O_SCALE, also nur noch Differenz zur eigentl. Lnge addieren) 
	movei   #obj_data,r0		; Adresse Daten fr OP-Liste
	load	(r0),r11		; Adresse laden
	movei   #olist_ram,r0		; Adresse Kopie OP-Liste im RAM
	load	(r0),r12		; Adresse laden
	move	r12,r7			; Adresse OP-Liste retten
	shrq	#3,r7			; geteilt / 8 fr OP
	movei	#TOTAL_OBJS,r0		; Adresse Anzahl Objecte
	load	(r0),r6			; Anzahl Objecte laden
	movei   #a_vdb,r0		; Adresse Y-Pos erste Bildschirmzeile
	load    (r0),r26		; Y-Pos erste Bildschirmzeile
	move	r11,r13			; Kopie Adresse Daten fr OP-Liste
	movei	#proc_obj,r5		; Sprungadresse fr Zhlschleife
	movei	#next_obj,r4		; Sprungadresse fr Object Check
	movei	#proc_obj3,r17		; Sprungadresse
	movei	#$FFFF0000,r18		; Variable um Zahl negativ zu machen
	movei	#32768,r19		; Variable fr Check ob Zahl negativ ist
	movei	#$ff,r20		; Byte ausmaskieren
	movei	#$ffff,r21		; Wort ausmaskieren 
	movei	#$7ff,r22		; um O_YPOS zu ermitteln
	moveq	#$f,r23			; um O_IWIDTH zu ermitteln
	movei	#$fff,r24		; Um O_XPOS zu ermitteln
	moveq	#4,r25			; fr STOP Object
        

; **** PHRASE 1	******************
proc_obj:
	addq	#O_TYPE,r11		; Adresse auf O_TYPE setzen
	loadb	(r11),r2		; O_TYPE laden
	cmpq	#5,r2			; Ist Object aktiv ? (5 = nein)
	jump	EQ,(r4)			; Nein, weiter mit nchstem Object

; Object Daten
proc_obj1:
	subq	#O_TYPE-O_DATA,r11	; Adresse auf O_DATA setzen
	load	(r11),r0	 	; Adresse der Spritedaten

	addq	#O_DWIDTH-O_DATA,r11	; Adresse auf O_DWIDTH setzen
	loadw	(r11),r28		; Breite in Phrases laden

	move	r26,r27			; Y-Pos erste Bildschirmzeile retten
	subq	#O_DWIDTH-O_YPOS,r11	; Adresse auf Y-Pos setzen
	loadw	(r11),r30		; Y-Pos Objekt laden

; Check ob Y-Pos negativ ist	
proc_obj1_0:
	cmp	r19,r30			; Ist Y-Pos negativ
	jr	CS,proc_obj1_1		; Nein
	nop
	or	r18,r30			; Y-Pos negativ machen
proc_obj1_1:	
	sub	r30,r27			; halbe Bildschirmzeilen auserhalb sichtbarem Bereich
	jr	PL,proc_obj2
	nop
	moveq	#0,r27			; keine Bildschirmzeilen auserhalb sichtbarem Bereich
	jr	T,proc_obj3
	nop
proc_obj2:
	move	r26,r30			; Y-Pos auf 1 sichtbare Zeile
	shrq	#1,r27			; ganze Bildschirmzeilen auserhalb sichtbarem Bereich
	shlq	#3,r28			; Breite in Phrases * 8 Byte pro Phrase
	mult	r27,r28			; Bildschirmzeilen auserhalb * Bytes pro Zeile
	add	r28,r0			; nicht sichtbare Bytes bergehen		
proc_obj3:
	shrq	#3,r0			; Adresse / 8
	shlq	#11,r0			; Platz fr Link Pointer schaffen

; Link Pointer fr nchstes Object setzen
	addq	#4,r7			; nchstes Object ist 4 Phrases weiter
	move	r7,r1			; Adresse in Object Liste fr nchstes Object

	shrq	#8,r1			; rechte 8 Bits ins nchste Langwort
	or	r1,r0			; OR mit Data Pointer
	store	r0,(r12)		; 1 Langwort Phrase 1 sichern
	addq	#4,r12			; Adresse anpasssen

	move	r7,r0			; Adresse Link Pointer
	and	r20,r0			; 1 Byte ausmaskieren
	shlq	#10,r0			; 10 Bits verschieben fr O_HEIGHT

; Hhe setzen
	addq	#O_HEIGHT-O_YPOS,r11	; Adresse auf O_HEIGHT setzen
	cmpq	#1,r2			; Scaled Bitmap Objekt?
	jr	NE,proc_obj4		; Nein
	loadw	(r11),r1		; Object Hhe laden
	subq	#1,r1			; Extra Zeile am unteren Rand bei Scaled Bitmap Objekt
proc_obj4:
	sub	r27,r1			; Hhe - nicht sichtbare Zeilen
	jr	PL,proc_obj5		; Weiter sol. Hhe nicht negativ
	nop	
	moveq	#0,r1			; Hhe auf 0 setzen
proc_obj5:	
	and	r21,r1			; 1 Wort ausmaskieren
	or	r1,r0			; OR mit Link Pointer
	shlq	#11,r0			; 11 Bits verschieben fr O_YPOS

; Y-Pos setzen
	and	r22,r30			; Nur 11 Bits fr Y-Pos benutzen	
	or	r30,r0			; OR mit Link Pointer und Hhe
	shlq	#3,r0			; 3 Bits verschieben fr O_TYPE
	
; O-Type setzen
	or	r2,r0			; OR mit Object Type
	store	r0,(r12)		; 2 Langwort Phrase 1 schreiben		
	addq	#4,r12			; Adresse anpasssen

	
; **** PHRASE 2	******************
; O-Firstpix setzen
	addq	#O_FIRSTPIX-O_HEIGHT,r11 ; Adresse O_FIRSTPIX laden
	loadb	(r11),r0		; Object Firstpix laden
	shlq	#4,r0			; 4 Bits verschieben


; Object Flags setzen
	subq	#O_FIRSTPIX-O_FLAGS,r11	; Adresse O_FLAGS setzen
	loadb	(r11),r1		; Object Flags laden
	or	r1,r0			; OR mit Object Flags
	shlq	#7,r0			; 7 Bits verschieben fr INDEX	

; Object Index setzen
	addq	#O_INDEX-O_FLAGS,r11	; Adresse O_INDEX setzen
	loadb	(r11),r1		; Object Index laden
	or	r1,r0			; OR mit Object Index
	shlq	#6,r0			; 6 Bits verschieben

; Object Breite setzen
	subq	#O_INDEX-O_IWIDTH,r11	; Adresse O_IWIDTH setzen
	loadw	(r11),r1		; Object Breite laden
	move	r1,r2			; Object Breite merken
	shrq	#4,r1			; 4 Bits gehen ins nchtse Langwort
	or	r1,r0			; OR 
	store	r0,(r12)		; 1 Langwort Phrase 2 schreiben
	addq	#4,r12			; Adresse anpasssen
	and	r23,r2			; unterste 4 Bits von O_IWIDTH
	shlq	#10,r2			; 10 Bits verschieben fr O_DWIDTH

; Object Breite 2 setzen
	subq	#O_IWIDTH-O_DWIDTH,r11	; Adresse O_DWIDTH setzen
	loadw	(r11),r0		; Object Breite 2 laden
	or	r2,r0			; OR mit O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr PITCH

; Object Pitch setzen
	addq	#O_PITCH-O_DWIDTH,r11	; Adresse O_PITCH setzen
	loadb	(r11),r1		; Object Pitch laden
	or	r1,r0			; OR mit O_IWIDTH und O_DWIDTH
	shlq	#3,r0			; 3 Bits verschieben fr O_DEPTH

; Object Depth setzen
	subq	#O_PITCH-O_DEPTH,r11	; Adresse O_DEPTH setzen
	loadb	(r11),r1		; Object Depth laden
	or	r1,r0			; OR mit O_IWIDTH, O_DWIDTH und O_PITCH
	shlq	#12,r0			; 12 Bits verschieben fr O_XPOS

; Object X-Pos setzen	
	subq	#O_DEPTH-O_XPOS,r11	; Adresse O_XPOS setzen
	loadw	(r11),r1		; Object X-Pos laden
	and	r24,r1			; Nur 12 Bits fr O_XPOS benutzen
	or	r1,r0			; OR
	store	r0,(r12)		; 2 Langwort Phrase 2 schreiben
	addq	#8,r12			; Adresse anpasssen (+8 wegen O_SCALE)
				
; **** PHRASE 3	******************
	addq	#O_SCALE-O_XPOS,r11	; Adresse O_SCALE setzen
	load	(r11),r0		; Object Scale laden
	store	r0,(r12)		; Object Scale schreiben
	addq	#12,r12			; Adresse anpassen

next_obj:
	add	r3,r13			; Auf nchstes Object setzen (+ OBJSIZE)
	subq	#1,r6			; Anzahl Objecte - 1
	jump	NE,(r5)			; Wiederholen sol. > 0
	move	r13,r11			; Arbeitsregister wiederherstellen

; STOP Object am Ende der Liste schreiben
	addq	#4,r12			; Adresse anpassen
	store	r25,(r12)		; Object Type 4 (STOP OBJECT) schreiben		

; GPU stoppen
	moveq	#0,r30
	movei	#G_CTRL,r31
	store	r30,(r31)
	
	
	.END
