;----------------------------------------------------------------------------
; Project: Janalog: A testprogram for analog input
;
;
; Copyright (c) 2003 Matthias Domin
;
; Object-List-sourcecode:
; Copyrigth (c) 2002 Duranik 
; ALL RIGHTS RESERVED
;----------------------------------------------------------------------------
; Revision History:
;----------------------------------------------------------------------------



	.TEXT
	.68000
	.NOCLEAR


	INCLUDE "Jaguar.inc"			; ATARI Jaguar Definitionen
	INCLUDE	"Obj_List.inc"			; Object List Definitionen



; Labels in mytext.s
    .extern do_text2
    .extern clear_text2
    .extern make_fonts
; End of Labels in mytext.s


        ; Anzahl Objekte:
	TOTAL_OBJS	EQU	3


;-----------------------------------------------------------------------
; Jaguar init
;-----------------------------------------------------------------------
INIT:             move    #$2700,sr
                  lea     $1000.w,sp
                  lea     $F00000,a0
                  move.l  #$070007,d0           ; big endian
                  move.l  d0,$210C(a0)
                  move.l  d0,$F1A10C
                  moveq #0,d0
                  move.l d0,$2114(a0)           ; stop gpu
                  move.l d0,$f1a114             ; stop dsp
                  move.l d0,$2100(a0)           ; disable GPU-IRQs
                                                ; disable DSP-IRQs
                  move.l #%10001111100000000,$f1a100
                  move.l #%111111<<8,$f10020    ; clear and disable IRQs

                  move.l  d0,0.w
                  moveq   #4,d0
                  move.l  d0,4.w
                  moveq   #0,d0
                  move.l  d0,$20(a0)            ; set OP to STOP-OBJECT
                  move.w  d0,$26(a0)            ; clear OP-Flag
                  move.l  d0,$2A(a0)            ; border black
                  move.w  d0,$56(a0)            ; set CRY mode to color/not BW
                  move.w  d0,$58(a0)            ; background black
                  move.l  d0,$50(a0)            ; stop PIT
                  move.l  d0,$f10000            ; stop JPIT1
                  move.l  d0,$f10004            ; stop JPIT2
                  move.l  #$1F00<<16,$E0(a0)    ; clear pending irqs
                  move.w  #$7fff,$4e(a0)        ; no VI
                  lea     dummy_irq(pc),a0
                  move.l  a0,$0100.w
                  bra.s   INIT1
dummy_irq:        move.l #$1f00<<16,$f000e0
                  rte
INIT1:            moveq #0,d0
                  moveq #0,d1
                  moveq #0,d2
                  moveq #0,d3
                  moveq #0,d4
                  moveq #0,d5
                  moveq #0,d6
                  moveq #0,d7
                  move.l d0,a0
                  move.l d0,a1
                  move.l d0,a2
                  move.l d0,a3
                  move.l d0,a4
                  move.l d0,a5
                  move.l d0,a6
                  move.l a0,usp

;;;;;;; move.l  #0,G_CTRL   ; stop GPU
;;;;;;; move.l  #0,D_CTRL   ; stop DSP
;;;;;;; move.l  #0,G_FLAGS   ; init GPU Flags
;;;;;;; move.l  #0,D_FLAGS   ; init DSP Flags
;;;;;;; move.l #$00070007,G_END  ; GPU Big Endian Mode
;;;;;;; move.l #$00070007,D_END  ; DSP Big Endian Mode
;;;;;;; move.w #$35cc,MEMCON2   ; Big Endian Mode
;;;;;;; move.l  VI,s_vi    ; save old adress VI
;;;;;;; move.w  #$FFFF,VI   ; stop Video Interrupt
;;;;;;; move.l  sp,s_sp    ; save old Stackpointer
;;;;;;; move.l  #INITSTACK,sp   ; init Stackpointer


    move.l  #0,joycur
    move.l  #0,joyedge

    move.w  #0,xpos
    move.w  #0,ypos
;-----------------------------------------------------------------------
; init Videosystem
;-----------------------------------------------------------------------
	bsr	VideoIni			; init Videosystem
;	bsr	IntInit				; init Interrupts !!!!! neu !!!!!

; Create branch Objects for 2 OP-lists
	lea	olist1_branch,a0		; adress Branch Objekt
	move.l	#olist1_stop,d2			; adress Stop Objekt
	bsr	create_branch			; create Branch Objekt

	lea	olist2_branch,a0		; adress Branch Objekt
	move.l	#olist2_stop,d2			; adress Stop Objekt
	bsr	create_branch			; create Objekt erstellen

	move.l	#olist1,olist			; adresse active OP-list
	move.l	#olist2,olist_ram		; adress OP-Liste to create

	move.l	#olist1_stop,d0			; Adresse der Objekt Liste
	swap	d0				; Adresse vertauschen fr OP
	move.l	d0,OLP				; Adresse fr OP einstellen
;	move.w  #$6C7,VMODE			; Video Init 320x200 16 Bit RGB
    move.w  #$4c1,VMODE   ; Video Init 320x200 CRY

;    move.w    #$78FF,BG       ; Weiss? als CRY-Wert
;    move.l    #$FFFFFFFF,BORD1    ; Weiss? TrueColor-Wert

;-----------------------------------------------------------------------
; copy adresses in GPU and program in GPU RAM
;-----------------------------------------------------------------------
	move.l  olist_ram,$f03f44		; Adresse olist_ram 
	move.l  #obj_data,$f03f48		; Adresse obj_data
	move.l  #TOTAL_OBJS,$f03f4C		; Anzahl Objekte (TOTAL_OBJS)

    jsr     make_fonts

    lea.l   mypal,a0
    jsr     set_palette         ; load in the palette


; erste Bildschirmzeile	
	moveq   #0,d0
	move.w  a_vdb,d0
	andi.w  #$FFFE,d0
	move.l  d0,$f03f50

	lea	gpu_prog,a0			; adress GPU routine
	bsr	copy_binfile			; copy GPU routine


	bsr	IntInit				; init Interrupts !!!!! neu !!!!!

    move.l  #bild,text_bmp ; where to copy the text

;**********************************
;**    move.w    #$78FF,BG       ; Weiss? als CRY-Wert
;**    move.l    #$FFFFFFFF,BORD1    ; Weiss? TrueColor-Wert

    jsr     clrscreen

    ; draw a rectangle of 256*(256/2) pixels as plafield for the cursors
    move.l  #bild,a0
    move.b  #$44,d0   ; colour index 4
    move.l  #(256/2)-1,d1   ; y
.doyloop:
    move.l  #(256/2)-1,d2   ; x = 2 pixel per byte!
.doxloop:
    move.b  d0,(a0,d2)
    dbf     d2,.doxloop
    lea     320/2(a0),a0
    dbf     d1,.doyloop



; Print some text into the text-screen of the menu-screen
    move.l  #bild,text_bmp ; where to copy the text

    ; White text
    move.l  #wABC,text_font
    move.b  #0,zeil
    move.b  #14,spal
    move.l  #programname,text_adr
    bsr     do_text2

    move.b  #1,zeil
    move.b  #13,spal
    move.l  #author,text_adr
    bsr     do_text2

    move.w  #50,DELAYVAL
;-----------------------------------------------------------------------
; Main program
;-----------------------------------------------------------------------
main:
    stop    #$2000              ; stop 68K until next IRQ

    move.l  olist_ram,$f03f44       ; Adresse olist_ram 
    move.l  #obj_data,$f03f48       ; Adresse obj_data
    move.l  #TOTAL_OBJS,$f03f4C     ; Anzahl Objekte (TOTAL_OBJS)
	bsr     start_gpu			; start GPU object routine
	bsr     readpad				; Joypad abfragen

GPIO5       .equ $f17c00


    ; Joyport 0
;   move.w  #$0,GPIO5       ; $00 = x-axis of joyport 0
    move.w  #$4,GPIO5       ; $04 = set poll bit
    move.w  DELAYVAL,d1
.waitloop00:                ; wait 40us
    nop
    dbf     d1,.waitloop00
;*    bsr     readdelay

    move.w  GPIO5,xpos

;   move.w  #$1,GPIO5       ; $00 = y-axis of joyport 0
    move.w  #$5,GPIO5       ; $04 = set poll bit
    move.w  DELAYVAL,d1
.waitloop01:                ; wait 40us
    nop
    dbf     d1,.waitloop01
;*    bsr     readdelay

    move.w  GPIO5,ypos

    ; Joyport 1
;   move.w  #$2,GPIO5       ; $02 = x-axis of joyport 1
    move.w  #$6,GPIO5       ; $04 = set poll bit
    move.w  DELAYVAL,d1
.waitloop10:                ; wait 40us
    nop
    dbf     d1,.waitloop10
;*    bsr     readdelay

    move.w  GPIO5,x2pos

;   move.w  #$3,GPIO5       ; $03 = y-axis of joyport 1
    move.w  #$7,GPIO5       ; $04 = set poll bit
    move.w  DELAYVAL,d1
.waitloop11:                ; wait 40us
    nop
    dbf     d1,.waitloop11
;*    bsr     readdelay

    move.w  GPIO5,y2pos

    ; set the two cursor-sprites
    move.w  xpos,d0
    and.w   #$00ff,d0
    add.w   #60,d0
    sub.w   #12,d0  ; the half of the cross in the upper left corner
    move.w  d0,curx

    move.w  ypos,d0
    and.w   #$00fe,d0   ; even numbers!!
    add.w   #86,d0
    sub.w   #2*12,d0  ; the half of the cross in the upper left corner
    move.w  d0,cury

    move.w  x2pos,d0
    and.w   #$00ff,d0
    add.w   #60,d0
    sub.w   #12,d0  ; the half of the cross in the upper left corner
    move.w  d0,cur2x

    move.w  y2pos,d0
    and.w   #$00fe,d0   ; even numbers!!
    add.w   #86,d0
    sub.w   #2*12,d0  ; the half of the cross in the upper left corner
    move.w  d0,cur2y


    ; Out  joyport 0 values
    lea     xpos,a4
    lea     xwert,a5
    bsr     hexwandeln
    move.b  #11,zeil
    move.b  #0,spal        ; output at the left edge of the screen
    move.l  #xtext,text_adr
    bsr     do_text2


    lea     ypos,a4
    lea     ywert,a5
    bsr     hexwandeln
    move.b  #12,zeil
    move.b  #0,spal        ; output at the left edge of the screen
    move.l  #ytext,text_adr
    bsr     do_text2


    ; Out  joyport 1 values
    lea     x2pos,a4
    lea     xwert,a5
    bsr     hexwandeln
    move.b  #11,zeil
    move.b  #34,spal        ; output at the right edge of the screen
    move.l  #xtext,text_adr
    bsr     do_text2


    lea     y2pos,a4
    lea     ywert,a5
    bsr     hexwandeln
    move.b  #12,zeil
    move.b  #34,spal        ; output at the right edge of the screen
    move.l  #ytext,text_adr
    bsr     do_text2


    ; Output the Delay value:
    lea     DELAYVAL,a4
    lea     delayvalwert,a5
    bsr     scorewandeln
    move.b  #8,zeil
    move.b  #10,spal        ; output at the right edge of the screen
    move.l  #delayvaltext,text_adr
    bsr     do_text2


    move.l  joycur,d0
    btst.l  #JOY_UP,d0    ; up
    beq.s   .testdown
    sub.w   #1,DELAYVAL
    bpl.s   .testdown
    move.w  #0,DELAYVAL
    
.testdown:
    btst.l  #JOY_DOWN,d0    ; down
    beq.s   .testnext
    add.w   #1,DELAYVAL
    cmp.w   #5000,DELAYVAL
    bmi.s   .testnext
    move.w  #0,DELAYVAL

.testnext:
    move.l  joycur,d0
	btst.l	#KEY_STAR,d0	; *
	beq.s	.do_loop
	btst.l	#KEY_HASH,d0	; *+# = leave program!
	beq.s	.do_loop
	bra.s	back



.do_loop:
	bra     main

;************************* game over **************************
back:   
          move.l    #0,$f02114
          move.w    #$4c0,VMODE

	illegal
          rts


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; We're supposed to write our analog-input request, then wait 40us before
; reading result.  With a 13mhz clock on the 68000, that's about 52000
; cycles.  Therefore, we should time for about 52000 cycles then return.
; Provided by Thunderbird.

readdelay:
	move.l	#2500,d0
.dloop:
	sub.l	#1,d0
	bne	.dloop
	rts


;--------------------------------------------------------------------------
clrscreen:
; clear the bitmap
    move.l  #bild,a1
    move.l  #((320/2*200)/4)-1,d0
    moveq.l #0,d1
clear1:
    move.l  d1,(a1)+
    dbf     d0,clear1
    rts

;--------------------------------------------------------------------------
set_palette:        
;A0 must be the address of the palette data
;palette data is 256 words of colors
    lea.l   CLUT,a1             ;get address of color lookup table
    move.w  #255,d0             ;number of colors to set
.10:
    move.w  (a0)+,(a1)+         ;put color value into color lookup table
    dbra    d0,.10              ;continue through palette table
    rts       

;*******************************************************************
scorewandeln:       movem.l             d0-d4/a0-a3,-(sp)   ; Wandelt den dualen
          move.w    #-1,d1                  ;  SCORE / HISCORE
          move.w    #-1,d2                  ; in den ASCII-String
          move.w    #-1,d3                  ; SCORNUM /HISCORNUM
          move.w    #-1,d4                  ; um
          move.w    (a4),d0
ziff1:    sub.w     #10000,d0
          addq.w    #1,d4
          cmpi.w    #0,d0
          bpl       ziff1
          add.w     #10000,d0
ziff2:    sub.w     #1000,d0
          addq.w    #1,d3
          cmpi.w    #0,d0
          bpl       ziff2
          add.w     #1000,d0
ziff3:    sub.w     #100,d0
          addq.w    #1,d2
          cmpi.w    #0,d0
          bpl       ziff3
          add.w     #100,d0
ziff4:    sub.w     #10,d0
          addq.w    #1,d1
          cmpi.w    #0,d0
          bpl       ziff4
          add.w     #10,d0
          addi.w    #48,d0
          addi.w    #48,d1
          addi.w    #48,d2
          addi.w    #48,d3
          addi.w    #48,d4
          move.b    d4,(a5)
          move.b    d3,1(a5)
          move.b    d2,2(a5)
          move.b    d1,3(a5)
          move.b    d0,4(a5)
          movem.l   (sp)+,d0-d4/a0-a3
          rts       
;*************************************************************
hexwandeln:
        movem.l             d0-d4/a0-a3,-(sp)   ; Wandelt den dualen
        moveq.l #0,d0
        move.w  (a4),d0
        move.l  d0,d1
        move.l  d0,d2
        move.l  d0,d3


        asr.w   #8,d0
        asr.w   #4,d0   ; 12 bits
        asr.w   #8,d1            
        asr.w   #4,d2            
;       asr.w   #0,d3            

        and.w   #$0f,d0
        and.w   #$0f,d1
        and.w   #$0f,d2
        and.w   #$0f,d3

        lea.l   hexstring,a0

        move.b    (a0,d0.w),0(a5)
        move.b    (a0,d1.w),1(a5)
        move.b    (a0,d2.w),2(a5)
        move.b    (a0,d3.w),3(a5)
        move.b    #0,4(a5)  ; terminate the string  
        movem.l   (sp)+,d0-d4/a0-a3
        rts       






;--------------------------------------------------------------------------
; Video System initalisieren
;--------------------------------------------------------------------------
VideoIni:
	move.w	CONFIG,d0			; Also is joystick register
	andi.w	#$10,d0				; 0 = PAL, 1 = NTSC
	beq	palvals

	move.w	#NTSC_HMID,d2
	move.w	#NTSC_WIDTH,d0
	move.w	#NTSC_VMID,d6
	move.w	#NTSC_HEIGHT,d4
	bra	calc_vals

palvals:
	move.w	#PAL_HMID,d2
	move.w	#PAL_WIDTH,d0
	move.w	#PAL_VMID,d6
	move.w	#PAL_HEIGHT,d4

calc_vals:
  
	move.w	d0,width
	move.w	d4,height
	move.w	d0,d1
	asr	#1,d1				; Width/2
	sub.w	d1,d2				; Mid - Width/2


	add.w	#4,d2				; (Mid - Width/2)+4
	sub.w	#1,d1				; Width/2 - 1
	ori.w	#$400,d1			; (Width/2 - 1)|$400
	move.w	d1,a_hde
	move.w	d1,HDE
	move.w	d2,a_hdb
	move.w	d2,HDB1
	move.w	d2,HDB2
	move.w	d6,d5       ; VMID
	sub.w	d4,d5       ; HEIGHT-VMID


	move.w	d5,a_vdb
	andi.w	#$FFFE,d5

	add.w	d4,d6
	move.w	d6,a_vde
	move.w	a_vdb,VDB
	move.w	#$FFFF,VDE
	move.l	#0,BORD1			; Black border
	move.l	#0,BG				; Line Buffer black
	rts



;-------------------------------------------------------------------------
; Interrupts initalisieren
;-------------------------------------------------------------------------
IntInit:
	move.l	LEVEL0,s_level2
	move.l	VI,s_vi
	move.l	INT1,s_int1
	move.w	sr,s_sr

	move.l	#Frame,LEVEL0

	move.w  a_vde,d0
	ori.w   #1,d0
	move.w  d0,VI

	move.w  #1,INT1

	move.w  sr,d0
	andi.w  #$F8FF,d0
	move.w  d0,sr
	rts



;-------------------------------------------------------------------------	
; Interrupt Routine
;-------------------------------------------------------------------------	
Frame:	movem.l	d0-d1,-(sp)
	move.l	olist_ram,d0			; Adresse neue OP-Liste laden
	move.l	olist,d1			; Adresse aktive OP-Liste laden
	move.l	d1,olist_ram			; Adresse neue OP-Liste = Adresse aktive OP-Liste
	move.l	d0,olist			; Adresse aktive OP-Liste = Adresse neue OP-Liste
	
	move.l	d1,$f03f44			; Adresse olist_ram fr GPU	

	subq.l	#4,d0				; Adresse OP-Liste auf Branch Objekt
	swap	d0				; Adresse vertauschen fr OP
	move.l	d0,OLP				; Adresse fr OP einstellen

	move.w	#$101,INT1
	move.w	#0,INT2
	movem.l	(sp)+,d0-d1
	rte



;--------------------------------------------------------------------------
; Branch Objekte fr Objekt Listen erstellen
;--------------------------------------------------------------------------
; In:	A0	; Adresse Branch Objekt
; 	D2	; Adresse Stop Objekt
create_branch:
; Erstes BRANCH Objekt (branch if YPOS < a_vdb)
	clr.l	d1
	move.l	#(BRANCHOBJ|O_BRGT),d0  	; YPOS < VC

; Format Link erstellen
	movem.l	d2-d3,-(sp)
	andi.l	#$3FFFF8,d2			; Ensure alignment/valid address
	move.l	d2,d3				; Make a copy

	swap	d2				; This section places bits 10-3
	clr.w	d2				; in bits 31-24. It saves cycles
	lsl.l	#5,d2				; over using three shifts.
	or.l	d2,d0

	lsr.l	#8,d3				; Put bits 21-11 in bits 42-32
	lsr.l	#3,d3
	or.l	d3,d1
	movem.l	(sp)+,d2-d3			; Restore regs
; Ende Format Link erstellen

	move.w	a_vdb,d3			; oberer Rand
	lsl.w	#3,d3				; Make it bits 13-3
	or.w	 d3,d0

	move.l	d1,(a0)+
	move.l	d0,(a0)+			; First OBJ is done.

; Zweites BRANCH Objekt (branch if YPOS > a_vde)
	andi.l	#$FF000007,d0			; Mask off CC and YPOS
	ori.l	#O_BRLT,d0			; $8000 = YPOS < VC
	move.w	a_vde,d3			; unterer Rand
	lsl.w	#3,d3				; Make it bits 13-3
	or.w	d3,d0

	move.l  d1,(a0)+			; Second OBJ is done
	move.l  d0,(a0)+
	rts



;-------------------------------------------------------------------------
; This copies the BIN file at location (a0) to its intended destination.
;-------------------------------------------------------------------------
copy_binfile:
	move.l	(a0)+,a1			; Get starting address (destination)
	move.l	(a0)+,d0			; Get length of code segment...
	asr	#2,d0				; Divide by 4 (do longs)
.loop:	move.l	(a0)+,(a1)+
	dbra	d0,.loop
	rts



;-------------------------------------------------------------------------
; GPU starten
;-------------------------------------------------------------------------
start_gpu:
	move.l	#G_RAM,G_PC			; Start up GPU
	move.l	#1,G_CTRL
	rts





;-----------------------------------------------------------------------
; Joypad abfragen
;-----------------------------------------------------------------------
readpad:
; scan for player 1
	move.l	#$f0fffffc,d1			; d1 = Joypad data mask
	moveq.l	#-1,d2				; d2 = Cumulative joypad reading

	move.w	#$81fe,JOYSTICK
	move.l	JOYSTICK,d0			; Read joypad,pause button,A button
	or.l	d1,d0				; Mask off unused bits
	ror.l	#4,d0
	and.l	d0,d2				; d2 = xxAPxxxx RLDUxxxx xxxxxxxx xxxxxxxx
	move.w	#$81fd,JOYSTICK
	move.l	JOYSTICK,d0			; Read *741 keys,B button
	or.l	d1,d0				; Mask off unused bits
	ror.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxxxxxxx xxxxxxxx
	move.w	#$81fb,JOYSTICK
	move.l	JOYSTICK,d0			; Read 2580 keys,C button
	or.l	d1,d0				; Mask off unused bits
	rol.l	#6,d0
	rol.l	#6,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxxx 2580xxxx
	move.w	#$81f7,JOYSTICK
	move.l	JOYSTICK,d0			; Read 369# keys,Option button
	or.l	d1,d0				; Mask off unused bits
	rol.l	#8,d0
	and.l	d0,d2				; d2 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== inputs active low

	moveq.l	#-1,d1
	eor.l	d2,d1				; d1 = xxAPxxBx RLDU741* xxCxxxOx 2580369# <== now inputs active high

	move.l	joycur,d0			; old joycur needed for determining the new joyedge
	move.l	d1,joycur			; Current joypad reading stored into joycur
	eor.l	d1,d0
	and.l	d1,d0
	move.l	d0,joyedge			; joypad,buttons,keys that were just pressed
	rts


;-----------------------------------------------------------------------
; Daten
;-----------------------------------------------------------------------
    .DATA
    .QPHRASE
joyedge:    dc.l    0
joycur:     dc.l    0
    .QPHRASE
gpu_prog:   incbin  "GPU_PROG.BIN"

;-----------------------------------------------------------------------
; Objekt Definitionen
;-----------------------------------------------------------------------
	.QPHRASE
obj_data:

;***** Text-screen ******
x:      dc.w    60          ; (O_XPOS)  X-Pos Object auf dem Bildschirm
y:      dc.w    86          ; (O_YPOS)  Y-Pos Object auf dem Bildschirm
        dc.l    bild            ; (O_DATA)  Adresse der Object Daten
        dc.w    200         ; (O_HEIGHT)    Hoehe des Objects in Pixel
        dc.w    320/2/8         ; (O_IWIDTH)    Breite des Objects in Phrases
        dc.w    320/2/8         ; (O_DWIDTH)    Offset zur nchsten Linie des Objects in Phrases
        dc.b    0           ; (O_FLAGS) Flags wie Object gezeichnet werden soll
        dc.b    0           ; (O_FIRSTPIX)  wieviele Bits am Anfang der Object Daten uebergehen
        dc.b    0           ; (O_TYPE)  Object Flags (0=Bitmap, 1=Scale, 2=GPU, 3=Branch, 4=Stop, 5=nicht aktiv)
        dc.b    2           ; (O_DEPTH) Anzahl Farben des Objects
        dc.b    1           ; (O_PITCH) Pitch
        dc.b    0           ; (O_INDEX) Index in CLUT fuer Objecte mit Farbpalette 
        dc.w    $20         ; (O_SCALE) Remainder
        dc.b    $30          ;       Y-Scaling Faktor
        dc.b    $30          ;       X-Skaling Faktor


;***Cursor***********
curx:   DC.w 60   ; o_xpos
cury:   DC.w 70  ; o_ypos
curadr: DC.l cursor1 ; o_data
        DC.w 32    ; o_height
        DC.w 32/2/8 ; o_dwidth
        DC.w 32/2/8 ; o_iwidth
        DC.b 4    ; o_flags   ; Transparent!!
        DC.b 0    ; o_firstpix
        DC.b 0    ; o_type    ; Bitmap (nicht skaliert)
        DC.b 2    ; o_depth   ; 4bit pixelwidth
        DC.b 1    ; o_pitch
        DC.b 0    ; o_index
curmodif:    DC.w $20
curyscale:   DC.b $30
curxscale:   DC.b $30

;***Cursor***********
cur2x:   DC.w 60   ; o_xpos
cur2y:   DC.w 70  ; o_ypos
cur2adr: DC.l cursor2 ; o_data
        DC.w 32    ; o_height
        DC.w 32/2/8 ; o_dwidth
        DC.w 32/2/8 ; o_iwidth
        DC.b 4    ; o_flags   ; Transparent!!
        DC.b 0    ; o_firstpix
        DC.b 0    ; o_type    ; Bitmap (nicht skaliert)
        DC.b 2    ; o_depth   ; in fact 8 bit / pixel  , but shown as 16bit per pixel!!
        DC.b 1    ; o_pitch
        DC.b 0    ; o_index
cur2modif:    DC.w $20
cur2yscale:   DC.b $30
cur2xscale:   DC.b $30



;#######################################################################
;#######################################################################
;#######################################################################

;-----------------------------------------------------------------------
; Objektliste
;-----------------------------------------------------------------------
 .QPHRASE

  rept 4    ; 4 longs = 2 phrases
  dc.l 0    ; !!!! NEW NEW NEW Scaled objects need 4 phrase alignment NEW NEW NEW !!!!
  endr

olist1_branch:
  rept 4
  dc.l 0   ; 2 Branch Objekte   = 2 * 1 Phrase = 2*8 = 16 bytes = 4 longs
  endr

olist1:
  rept ((8*TOTAL_OBJS)+2)
  dc.l 0
  endr

olist1_stop:
  dc.l 0   ; 1 Teil STOP Objekt
  dc.l 4   ; 2 Teil STOP Objekt


 .QPHRASE

  rept 4
  dc.l 0    ;!!!! NEW NEW NEW Scaled objects need 4 phrase alignment NEW NEW NEW!!!!
  endr

olist2_branch:
  rept 4
  dc.l 0   ; 2 Branch Objekte
  endr

olist2: 
  rept ((8*TOTAL_OBJS)+2)
  dc.l 0
  endr

olist2_stop:
  dc.l 0   ; 1 Teil STOP Objekt
  dc.l 4   ; 2 Teil STOP Objekt



    even
programname: dc.b   "Janalog V0.2",0
author:     dc.b    "Matthias Domin",0
xtext:      dc.b    "X="
xwert:      dc.b    "00000",0
ytext:      dc.b    "Y="
ywert:      dc.b    "00000",0
delayvaltext:      dc.b    "Delay="
delayvalwert:      dc.b    "00000",0

hexstring:  dc.b    "0123456789ABCDEF"

    even
wABC:   incbin "abc3.img"

    qphrase
cursor1: incbin "cursor1.spr"

    qphrase
cursor2: incbin "cursor2.spr"

    qphrase
cursor:
    dc.l    $00000000, $10101010, $10101010, $00000000
    dc.l    $00000000, $1010ffff, $ffff1010, $00000000
    dc.l    $10101010, $1010ffff, $ffff1010, $10101010
    dc.l    $1010ffff, $ffffffff, $ffffffff, $ffff1010
    dc.l    $1010ffff, $ffffffff, $ffffffff, $ffff1010
    dc.l    $10101010, $1010ffff, $ffff1010, $10101010
    dc.l    $00000000, $1010ffff, $ffff1010, $00000000
    dc.l    $00000000, $10101010, $10101010, $00000000


    qphrase
mypal:
 dc.w $0000 ; 0=Black (also the transparenzy colour!)
 dc.w $88ff ; 1=White
 dc.w $ff70 ; 2=Dark Yellow
 dc.w $ffff ; 3=Light Yellow
 dc.w $8f70 ; 4=Dark Green
 dc.w $8fff ; 5=Light Green
 dc.w $33ff ; 6=
 dc.w $0000 ; 7=Schwarz fr Bildschirm
 dc.w $88ff ; 8=White for wABC-font
 dc.w $f8f0 ; 9=Orange
 dc.w $aaff ;10=
 dc.w $88c0 ;11=Light Gray
 DC.w $bbff ;12=
 dc.w $ddff ;13=
 dc.w $12aa ;14=
 dc.w $88ff ;15=White
    
          DC.w $78ff,$01ff,$02ff,$03ff,$04ff,$05ff,$06ff,$07ff,$08ff,$09ff,$0aff,$0bff,$0cff,$0dff,$0eff,$0fff
          DC.w $10ff,$11ff,$12ff,$13ff,$14ff,$15ff,$16ff,$17ff,$18ff,$19ff,$1aff,$1bff,$1cff,$1dff,$1eff,$1fff
          DC.w $20ff,$21ff,$22ff,$23ff,$24ff,$25ff,$26ff,$27ff,$28ff,$29ff,$2aff,$2bff,$2cff,$2dff,$2eff,$2fff
          DC.w $30ff,$31ff,$32ff,$33ff,$34ff,$35ff,$36ff,$37ff,$38ff,$39ff,$3aff,$3bff,$3cff,$3dff,$3eff,$3fff
          DC.w $40ff,$41ff,$42ff,$43ff,$44ff,$45ff,$46ff,$47ff,$48ff,$49ff,$4aff,$4bff,$4cff,$4dff,$4eff,$4fff
          DC.w $50ff,$51ff,$52ff,$53ff,$54ff,$55ff,$56ff,$57ff,$58ff,$59ff,$5aff,$5bff,$5cff,$5dff,$5eff,$5fff
          DC.w $60ff,$61ff,$62ff,$63ff,$64ff,$65ff,$66ff,$67ff,$68ff,$69ff,$6aff,$6bff,$6cff,$6dff,$6eff,$6fff
          DC.w $70ff,$71ff,$72ff,$73ff,$74ff,$75ff,$76ff,$77ff,$78ff,$79ff,$7aff,$7bff,$7cff,$7dff,$7eff,$7fff
          DC.w $80ff,$81ff,$82ff,$83ff,$84ff,$85ff,$86ff,$87ff,$88ff,$89ff,$8aff,$8bff,$8cff,$8dff,$8eff,$8fff
          DC.w $90ff,$91ff,$92ff,$93ff,$94ff,$95ff,$96ff,$97ff,$98ff,$99ff,$9aff,$9bff,$9cff,$9dff,$9eff,$9fff
          DC.w $a0ff,$a1ff,$a2ff,$a3ff,$a4ff,$a5ff,$a6ff,$a7ff,$a8ff,$a9ff,$aaff,$abff,$acff,$adff,$aeff,$afff
          DC.w $b0ff,$b1ff,$b2ff,$b3ff,$b4ff,$b5ff,$b6ff,$b7ff,$b8ff,$b9ff,$baff,$bbff,$bcff,$bdff,$beff,$bfff
          DC.w $c0ff,$c1ff,$c2ff,$c3ff,$c4ff,$c5ff,$c6ff,$c7ff,$c8ff,$c9ff,$caff,$cbff,$ccff,$cdff,$ceff,$cfff
          DC.w $d0ff,$d1ff,$d2ff,$d3ff,$d4ff,$d5ff,$d6ff,$d7ff,$d8ff,$d9ff,$daff,$dbff,$dcff,$ddff,$deff,$dfff
          DC.w $e0ff,$e1ff,$e2ff,$e3ff,$e4ff,$e5ff,$e6ff,$e7ff,$e8ff,$e9ff,$eaff,$ebff,$ecff,$edff,$eeff,$efff
          DC.w $f0ff,$f1ff,$f2ff,$f3ff,$f4ff,$f5ff,$f6ff,$f7ff,$f8ff,$f9ff,$faff,$fbff,$fcff,$fdff,$feff,$ffff

;-----------------------------------------------------------------------
; BSS
;-----------------------------------------------------------------------
	.BSS

    .globl spal
    .globl zeil
    .globl text_bmp
    .globl text_adr
    .globl text_font
    .globl wABC
    .globl wABC2

	.QPHRASE
olist:		ds.l	1			; Adresse aktive OP-Liste
olist_ram:	ds.l	1			; Adresse zu erstellende OP-Liste
s_sp:		ds.l	1			; Adresse alter Stackpointer
s_level2:	ds.l	1
s_vi:		ds.l	1
s_int1:		ds.l	1
s_sr:		ds.w	1
height:		ds.w	1
a_vdb:		ds.w	1
a_vde:		ds.w	1
width:		ds.w	1
a_hdb:		ds.w	1
a_hde:		ds.w	1

DELAYVAL:   ds.w    1

xpos:       ds.w 1
ypos:       ds.w 1

x2pos:       ds.w 1
y2pos:       ds.w 1

spal:     DS.b 1 ; Text row
zeil:     DS.b 1 ; Text column
text_font: ds.l 1 ; address of the actual font
text_adr: DS.l 1 ; address of the actual text
text_bmp: ds.l 1 ; address of the output bitmap


 EVEN
wABC2: ds.b 5760 ; Space for 96 characters (15 bitlines with 4 Bytes = 8 4bit pixels)

	.QPHRASE
bild:		ds.w	320*200/2



	.END

