;****************************************************************************
;
;	JAGUAR.S  Hardware Equates for JAGUAR System
;
;	Copyright 1992 Atari U.S. Corp.
;
;****************************************************************************

;
;	JAGUAR REGISTERS
;

BASE	equ	$d00000		; JAGUAR Internal Register Base

MEMCON1	equ	BASE + 0	; Memory Configuration Register One
MEMCON2	equ	BASE + 2	; Memory Configuration Register Two
HC	equ	BASE + 4	; Horizontal Count
VC	equ	BASE + 6	; Vertical Count
LPH	equ	BASE + 8	; Horizontal Lightpen
LPV	equ	BASE + $0a	; Vertical Lightpen
CLK1	equ	BASE + $0c	; System Clock Frequency
CLK2	equ	BASE + $0e	; Video Clock Frequency
OB0	equ	BASE + $10	; Current Object Phrase
OB1	equ	BASE + $12
OB2	equ	BASE + $14
OB3	equ	BASE + $16
OLP	equ	BASE + $20	; Object List Pointer
OLPLO	equ	BASE + $20
OLPHI	equ	BASE + $22
ODP	equ	BASE + $24	; Object Data Pointer
OBF	equ	BASE + $26	; Object Processor Flag
VMODE	equ	BASE + $28	; Video Mode
BORD1	equ	BASE + $2a	; Border Color (Red & Green)
BORD2	equ	BASE + $2c	; Border Color (Blue)
HP	equ	BASE + $2e	; Horizontal Period
HBB	equ	BASE + $30	; Horizontal Blanking Begin
HBE	equ	BASE + $32	; Horizontal Blanking End
HS	equ	BASE + $34	; Horizontal Sync
HVS	equ	BASE + $36	; Horizontal Vertical Sync
HDB1	equ	BASE + $38	; Horizontal Display Begin One
HDB2	equ	BASE + $3a	; Horizontal Display Begin Two
HDE	equ	BASE + $3c	; Horizontal Display End
VP	equ	BASE + $3e	; Vertical Period
VBB	equ	BASE + $40	; Vertical Blanking Begin
VBE	equ	BASE + $42	; Vertical Blanking End
VS	equ	BASE + $44	; Vertical Sync
VDB	equ	BASE + $46	; Vertical Display Begin
VDE	equ	BASE + $48	; Vertical Display End
VEB	equ	BASE + $4a	; Vertical Equalization Begin
VEE	equ	BASE + $4c	; Vertical Equalization End
VI	equ	BASE + $4e	; Vertical Interrupt
PIT0	equ	BASE + $50	; Programmable Interrupt Timer (Lo)
PIT1	equ	BASE + $52	; Programmable Interrupt Timer (Hi)
HEQ	equ	BASE + $54	; Horizontal Equalization End
TEST1	equ	BASE + $56	; Undocumented Register - DO NOT USE
BG	equ	BASE + $58	; Background Color

INT1	equ	BASE + $e0	; CPU Interrupt Control Register
INT2	equ	BASE + $e2	; CPU Interrupt Resume Register

CLUT	equ	BASE + $400	; Color Lookup Table

LBUFA	equ	BASE + $800	; Line Buffer A
LBUFB	equ	BASE + $1000	; Line Buffer B
LBUFC	equ	BASE + $1800	; Line Buffer Current

;
;	GPU REGISTERS
;
GPU_FLAGS equ	BASE + $2100	; GPU Flags
GPU_MTXC equ	BASE + $2104	; GPU Matrix Control
GPU_MTXA equ	BASE + $2108	; GPU Matrix Address
GPU_BIGEND equ	BASE + $210c	; GPU Data Organization
GPU_PC	equ	BASE + $2110	; GPU Program Counter
GPU_CTRL equ	BASE + $2114	; GPU Operation Control/Status
GPU_HIDATA equ	BASE + $2118	; GPU Bus Interface high data
GPU_REMAIN equ	BASE + $211c	; GPU Division Remainder
GPU_RAM	equ	BASE + $3000	; GPU Internal RAM

;
;	BLTTER REGISTERS
;
BLIT_A1BASE	equ	BASE + $2200	; A1 Base Address
BLIT_A1FLAGS	equ	BASE + $2204	; A1 Control Flags
BLIT_A1CLIP	equ	BASE + $2208	; A1 Clipping Size
BLIT_A1PIXEL	equ	BASE + $220C	; A1 Pixel Pointer
BLIT_A1STEP	equ	BASE + $2210	; A1 Step (Integer Part)
BLIT_A1STEPF	equ	BASE + $2214	; A1 Step (Fractional Part)
BLIT_A1PIXELF	equ	BASE + $2218	; A1 Pointer (Fractional)
BLIT_A1INC	equ	BASE + $221C	; A1 Increment (Integer Part)
BLIT_A1INCF	equ	BASE + $2220	; A1 Increment (Fractional Part)
BLIT_A2BASE	equ	BASE + $2224	; A2 Base Address
BLIT_A2FLAGS	equ	BASE + $2228	; A2 Control Flags
BLIT_A2MASK	equ	BASE + $222C	; A2 Address Mask
BLIT_A2PIXEL	equ	BASE + $2230	; A2 PIXEL
BLIT_A2STEP	equ	BASE + $2234	; A2 Step (Integer)

BLIT_CMD	equ	BASE + $2238	; Command
BLIT_COUNT	equ	BASE + $223C	; Counters
BLIT_SRCD	equ	BASE + $2240	; Source Data
BLIT_DSTD	equ	BASE + $2248	; Destination Data
BLIT_DSTZ	equ	BASE + $2250	; Destination Z
BLIT_SRCZ1	equ	BASE + $2258	; Source Z (Integer)
BLIT_SRCZ2	equ	BASE + $2260	; Source Z (Fractional)
BLIT_PATD	equ	BASE + $2268	; Pattern Data
BLIT_IINC	equ	BASE + $2270	; Intensity Increment
BLIT_ZINC	equ	BASE + $2274	; Z Increment

; These equates are here to support the OLD BAD names
BLIT_A1WIN	equ	BASE + $2208	; A1 Window Size
BLIT_A1PTR	equ	BASE + $220C	; A1 Pointer
BLIT_A1FRAC	equ	BASE + $2218	; A1 Pointer (Fractional)
BLIT_A2PTR	equ	BASE + $2230	; A2 Pointer

LEDS	equ	BASE + $1f001	; If you say so, Leonard ..


